/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gloridifice.watersource.common.recipe.WaterFilterRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WaterFilterRecipeSerializer<T extends WaterFilterRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;
    private final Fluid inputFluid;
    private final Fluid outputFluid;

    public WaterFilterRecipeSerializer(IFactory<T> factory, Fluid inputFluid, Fluid outputFluid) {
        this.factory = factory;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"strainerIngredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"strainerIngredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"strainerIngredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        String fluidName = JSONUtils.func_151219_a((JsonObject)json, (String)"inputFluid", (String)"");
        String fluidName1 = JSONUtils.func_151219_a((JsonObject)json, (String)"outputFluid", (String)"");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        Fluid fluid1 = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName1));
        return this.factory.create(recipeId, group, ingredient, fluid, fluid1);
    }

    public T read(ResourceLocation resourceLocation, PacketBuffer packetBuffer) {
        String group = packetBuffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)packetBuffer);
        String input = packetBuffer.func_150789_c(19235);
        String output = packetBuffer.func_150789_c(19236);
        return this.factory.create(resourceLocation, group, ingredient, (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(input)), (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(output)));
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        ((WaterFilterRecipe)recipe).getStrainerIngredient().func_199564_a(buffer);
        buffer.func_211400_a(((WaterFilterRecipe)recipe).getInputFluid().getRegistryName().toString(), 19235);
        buffer.func_211400_a(((WaterFilterRecipe)recipe).getOutputFluid().getRegistryName().toString(), 19236);
    }

    public static interface IFactory<T extends WaterFilterRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, Fluid var4, Fluid var5);
    }
}

